/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.property.dialog;

import filenet.vw.api.VWEventDefinition;
import filenet.vw.api.VWFieldDefinition;
import filenet.vw.api.VWInstructionDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.property.VWAuthPropertyData;
import filenet.vw.toolkit.design.property.VWExpressionTextField;
import filenet.vw.toolkit.design.property.dialog.VWWaitForConditionDialog;
import filenet.vw.toolkit.design.property.event.IVWExpressionTextFieldListener;
import filenet.vw.toolkit.design.property.event.VWExpressionTextFieldEvent;
import filenet.vw.toolkit.design.property.images.VWImageLoader;
import filenet.vw.toolkit.design.property.resources.VWResource;
import filenet.vw.toolkit.design.property.tables.VWConditionsTableModel;
import filenet.vw.toolkit.utils.IVWPropertyData;
import filenet.vw.toolkit.utils.VWInstruction;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.event.IVWPropertyChangeListener;
import filenet.vw.toolkit.utils.event.VWPropertyChangeEvent;
import filenet.vw.toolkit.utils.table.VWQuickSort;
import filenet.vw.toolkit.utils.table.VWTable;
import filenet.vw.toolkit.utils.table.VWToolTipTableCellRenderer;
import filenet.vw.toolkit.utils.uicontrols.border.IVWToolbarBorderActionListener;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorderActionEvent;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorderClientActionEvent;
import filenet.vw.toolkit.utils.uicontrols.expressionbuilder.VWExpressionBuilderDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import javax.swing.table.TableColumn;

public class VWWaitForConditionParamPanel
extends JPanel
implements IVWToolbarBorderActionListener,
TableModelListener,
ListSelectionListener,
IVWExpressionTextFieldListener,
ActionListener,
MouseListener,
ItemListener,
FocusListener,
KeyListener,
IVWPropertyChangeListener {
    private static final int FIXED_COLUMN_WIDTH = 30;
    private VWToolbarBorder m_conditionsBorder = null;
    private VWTable m_conditionsTable = null;
    private VWConditionsTableModel m_conditionsTableModel = null;
    private VWToolbarBorder m_timeoutBorder = null;
    private JRadioButton m_infiniteRadioButton = null;
    private JRadioButton m_timeoutRadioButton = null;
    private ButtonGroup m_buttonGroup = null;
    private VWExpressionTextField m_timeoutTextField = null;
    private VWToolbarBorder m_resultDataFieldBorder = null;
    private JComboBox m_resultDataField = null;
    private BasicComboBoxEditor m_editor = null;
    private JTextField m_editorTextField = null;
    private JButton m_launchButton = null;
    private VWAuthPropertyData m_authPropertyData = null;
    private VWInstructionDefinition m_instructionDef = null;
    private boolean m_isFirstTime = true;
    private Dialog m_parentDialog = null;
    private Frame m_parentFrame = null;

    public VWWaitForConditionParamPanel(Dialog parent) {
        this.m_parentDialog = parent;
    }

    public VWWaitForConditionParamPanel(Frame parent) {
        this.m_parentFrame = parent;
    }

    public void init(VWAuthPropertyData authPropertyData, int nDisplayMode) {
        this.m_authPropertyData = authPropertyData;
        this.initControls(nDisplayMode);
        this.m_authPropertyData.getPropertyChangeEventNotifier().addPropertyChangeListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInstructionDefinition(VWInstructionDefinition instructionDef) {
        try {
            this.m_authPropertyData.displayWaitCursor(this);
            this.m_instructionDef = instructionDef;
            this.m_conditionsTableModel.reinitialize(this.m_instructionDef);
            if (this.m_conditionsTable.getRowCount() > 0) {
                this.m_conditionsTable.setRowSelectionInterval(0, 0);
            }
            this.m_conditionsBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_conditionsBorder.getClientPanel(), 1, 16));
            String timeoutString = VWInstruction.WaitForEventInstructionGetTimeOut(this.m_instructionDef);
            this.m_timeoutTextField.removeExpressionTextFieldListener(this);
            if (VWStringUtils.compare(timeoutString, "0") == 0) {
                this.m_timeoutTextField.setText("");
                this.m_timeoutTextField.setEnabled(false);
                this.m_infiniteRadioButton.removeActionListener(this);
                this.m_infiniteRadioButton.setSelected(true);
                this.m_infiniteRadioButton.addActionListener(this);
            } else {
                this.m_timeoutTextField.setText(timeoutString);
                this.m_timeoutTextField.setEnabled(true);
                this.m_timeoutRadioButton.removeActionListener(this);
                this.m_timeoutRadioButton.setSelected(true);
                this.m_timeoutRadioButton.addActionListener(this);
            }
            this.m_timeoutTextField.addExpressionTextFieldListener(this);
            this.initResultDataField();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        finally {
            this.m_authPropertyData.restoreDefaultCursor(this);
        }
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.m_isFirstTime) {
            this.m_isFirstTime = false;
            if (this.m_conditionsTable != null) {
                int[] columnSizes = new int[3];
                int width = (this.m_conditionsTable.getViewPortWidth() - 30) / 3;
                columnSizes[0] = 30;
                columnSizes[1] = width;
                columnSizes[2] = width * 2;
                this.m_conditionsTable.fitColumnsInTable(columnSizes);
            }
        }
    }

    public void actionPerformed(ActionEvent event) {
        Object src = event.getSource();
        if (src == this.m_infiniteRadioButton) {
            this.performInfiniteTimeoutAction();
        } else if (src == this.m_timeoutRadioButton) {
            this.performTimeoutExpressionAction();
        } else if (src == this.m_launchButton) {
            this.performLaunchButtonAction();
        }
    }

    public void textUpdated(VWExpressionTextFieldEvent event) {
        Object src = event.getSource();
        if (src == this.m_timeoutTextField) {
            this.performTimeoutUpdated();
        }
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.m_resultDataField) {
            this.performConditionResultDataFieldUpdated();
        }
    }

    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2) {
            this.onModifyConditionsTable();
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void tableChanged(TableModelEvent event) {
        int nRow = 0;
        switch (event.getType()) {
            case -1: {
                nRow = event.getLastRow() - 1;
                if (nRow >= 0) {
                    if (nRow == this.m_conditionsTable.getSelectedRow()) {
                        this.m_conditionsTable.clearSelection();
                    }
                    this.m_conditionsTable.setRowSelectionInterval(nRow, nRow);
                    break;
                }
                this.m_conditionsBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_conditionsBorder.getClientPanel(), 2, 32));
                break;
            }
            case 1: {
                nRow = event.getLastRow();
                if (nRow < 0) break;
                if (nRow == this.m_conditionsTable.getSelectedRow()) {
                    this.m_conditionsTable.clearSelection();
                }
                this.m_conditionsTable.setRowSelectionInterval(nRow, nRow);
            }
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting()) {
            this.m_conditionsBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_conditionsBorder.getClientPanel(), 2, Integer.MAX_VALUE));
            int nRowIndex = this.m_conditionsTable.getSelectedRow();
            if (this.m_conditionsTableModel != null && nRowIndex != -1) {
                int nRowCount;
                this.m_conditionsBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_conditionsBorder.getClientPanel(), 1, Integer.MAX_VALUE));
                if (nRowIndex == 0) {
                    this.m_conditionsBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_conditionsBorder.getClientPanel(), 2, 1));
                }
                if (nRowIndex == (nRowCount = this.m_conditionsTableModel.getRowCount()) - 1) {
                    this.m_conditionsBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_conditionsBorder.getClientPanel(), 2, 2));
                }
            }
        }
    }

    public void toolbarBorderActionPerformed(VWToolbarBorderActionEvent event) {
        try {
            Object src = event.getSource();
            int id = event.getID();
            if (src == this.m_conditionsBorder) {
                int nRowIndex = this.m_conditionsTable.getSelectedRow();
                switch (id) {
                    case 16: {
                        this.m_conditionsTableModel.addItem();
                        break;
                    }
                    case 32: {
                        this.onModifyConditionsTable();
                        break;
                    }
                    case 0x10000000: {
                        this.m_conditionsTableModel.deleteItem(nRowIndex);
                        int rowCount = this.m_conditionsTableModel.getRowCount();
                        if (rowCount != 0) break;
                        this.m_conditionsBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_conditionsBorder.getClientPanel(), 2, Integer.MAX_VALUE));
                        this.m_conditionsBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_conditionsBorder.getClientPanel(), 1, 16));
                        break;
                    }
                    case 1: {
                        this.onUp();
                        break;
                    }
                    case 2: {
                        this.onDown();
                    }
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void focusGained(FocusEvent event) {
    }

    public void focusLost(FocusEvent event) {
        if (event.getSource() == this.m_editorTextField) {
            this.performConditionResultDataFieldUpdated();
        }
    }

    public void keyPressed(KeyEvent event) {
    }

    public void keyReleased(KeyEvent event) {
    }

    public void keyTyped(KeyEvent event) {
        if (event.getSource() == this.m_editorTextField && event.getKeyChar() == '\n') {
            this.performConditionResultDataFieldUpdated();
        }
    }

    public void propertyChange(VWPropertyChangeEvent event) {
        switch (event.getID()) {
            case 511: 
            case 512: 
            case 513: 
            case 514: {
                this.initResultDataField();
            }
        }
    }

    protected void onUp() {
        try {
            int nRowIndex = this.m_conditionsTable.getSelectedRow();
            if (nRowIndex > 0) {
                this.m_conditionsTableModel.up(nRowIndex);
                this.m_conditionsTable.setRowSelectionInterval(nRowIndex - 1, nRowIndex - 1);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected void onDown() {
        try {
            int nRowIndex = this.m_conditionsTable.getSelectedRow();
            if (nRowIndex >= 0) {
                this.m_conditionsTableModel.down(nRowIndex);
                this.m_conditionsTable.setRowSelectionInterval(nRowIndex + 1, nRowIndex + 1);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void initControls(int nDisplayMode) {
        this.setLayout(new GridBagLayout());
        this.m_buttonGroup = new ButtonGroup();
        GridBagConstraints gbCons = new GridBagConstraints();
        gbCons.gridx = 0;
        gbCons.gridy = 0;
        gbCons.fill = 1;
        gbCons.weightx = 1.0;
        gbCons.weighty = 1.0;
        gbCons.anchor = 23;
        gbCons.gridheight = 1;
        gbCons.gridwidth = 1;
        gbCons.insets = new Insets(0, 0, 0, 10);
        if (nDisplayMode == 0) {
            gbCons.gridheight = 0;
            gbCons.insets = new Insets(0, 0, 0, 20);
        }
        this.m_conditionsBorder = new VWToolbarBorder(VWResource.s_conditionsStr, 0x10000033);
        this.m_conditionsBorder.addToolbarBorderActionNotifier(this);
        this.m_conditionsBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_conditionsBorder.getClientPanel(), 2, Integer.MAX_VALUE));
        this.m_conditionsBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_conditionsBorder.getClientPanel(), 1, 16));
        this.add((Component)this.m_conditionsBorder, gbCons);
        JPanel conditionsPanel = this.m_conditionsBorder.getClientPanel();
        conditionsPanel.setLayout(new GridLayout());
        this.m_conditionsTableModel = new VWConditionsTableModel(this.m_authPropertyData, this.m_instructionDef);
        this.m_conditionsTableModel.addTableModelListener(this);
        this.m_conditionsTable = new VWTable(this.m_conditionsTableModel);
        this.m_conditionsTable.setName("m_conditionsTable_VWWaitForConditionParamPanel");
        this.m_conditionsTable.addMouseListener(this);
        this.m_conditionsTable.setRowSelectionAllowed(true);
        this.m_conditionsTable.getSelectionModel().addListSelectionListener(this);
        this.m_conditionsTable.getSelectionModel().setSelectionMode(0);
        TableColumn tc = this.m_conditionsTable.getColumnModel().getColumn(0);
        if (tc != null) {
            tc.setMinWidth(30);
        }
        if ((tc = this.m_conditionsTable.getColumnModel().getColumn(1)) != null) {
            tc.setCellRenderer(new VWToolTipTableCellRenderer());
        }
        if ((tc = this.m_conditionsTable.getColumnModel().getColumn(2)) != null) {
            tc.setCellRenderer(new VWToolTipTableCellRenderer());
        }
        conditionsPanel.add(new JScrollPane(this.m_conditionsTable));
        gbCons.gridx = 0;
        ++gbCons.gridy;
        gbCons.fill = 2;
        gbCons.weightx = 1.0;
        gbCons.weighty = 0.0;
        gbCons.gridheight = 1;
        gbCons.gridwidth = 0;
        gbCons.insets = new Insets(0, 0, 0, 5);
        if (nDisplayMode == 0) {
            ++gbCons.gridx;
            gbCons.gridy = 0;
        }
        this.add((Component)this.getTimeoutPanel(), gbCons);
        ++gbCons.gridy;
        gbCons.insets = new Insets(4, 0, 0, 5);
        this.add((Component)this.getConditionResultPanel(), gbCons);
    }

    private JPanel getTimeoutPanel() {
        this.m_timeoutBorder = new VWToolbarBorder(VWResource.s_timeoutStr, 0x40000000);
        JPanel timeoutPanel = this.m_timeoutBorder.getClientPanel();
        timeoutPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbCons = new GridBagConstraints();
        gbCons.gridx = 0;
        gbCons.gridy = 0;
        gbCons.fill = 2;
        gbCons.weightx = 1.0;
        gbCons.weighty = 0.0;
        gbCons.anchor = 21;
        gbCons.gridheight = 1;
        gbCons.gridwidth = 1;
        gbCons.insets = new Insets(0, 0, 0, 0);
        this.m_infiniteRadioButton = new JRadioButton(VWResource.s_neverTimeoutStr);
        this.m_buttonGroup.add(this.m_infiniteRadioButton);
        this.m_infiniteRadioButton.addActionListener(this);
        timeoutPanel.add((Component)this.m_infiniteRadioButton, gbCons);
        ++gbCons.gridy;
        this.m_timeoutRadioButton = new JRadioButton(VWResource.s_expressionStr);
        this.m_buttonGroup.add(this.m_timeoutRadioButton);
        this.m_timeoutRadioButton.addActionListener(this);
        this.m_timeoutRadioButton.setSelected(true);
        timeoutPanel.add((Component)this.m_timeoutRadioButton, gbCons);
        ++gbCons.gridy;
        gbCons.insets = new Insets(0, 17, 2, 0);
        this.m_timeoutTextField = this.m_parentFrame != null ? new VWExpressionTextField(this.m_parentFrame, (IVWPropertyData)this.m_authPropertyData) : new VWExpressionTextField(this.m_parentDialog, (IVWPropertyData)this.m_authPropertyData);
        this.m_timeoutTextField.setName("m_timeoutTextField_VWWaitForConditionParamPanel");
        this.m_timeoutTextField.addExpressionTextFieldListener(this);
        timeoutPanel.add((Component)this.m_timeoutTextField, gbCons);
        return this.m_timeoutBorder;
    }

    private JPanel getConditionResultPanel() {
        this.m_resultDataFieldBorder = new VWToolbarBorder(VWResource.s_conditionResultDataField);
        JPanel resultDataFieldPanel = this.m_resultDataFieldBorder.getClientPanel();
        resultDataFieldPanel.setBorder(BorderFactory.createEtchedBorder());
        resultDataFieldPanel.setLayout(new BorderLayout());
        this.m_resultDataField = new JComboBox();
        this.m_resultDataField.setName("m_resultDataField_VWWaitForConditionParamPanel");
        this.m_resultDataField.addItemListener(this);
        this.m_resultDataField.setEditable(true);
        this.m_editor = new BasicComboBoxEditor();
        this.m_editor.getEditorComponent().addKeyListener(this);
        this.m_editor.getEditorComponent().addFocusListener(this);
        if (this.m_editor.getEditorComponent() instanceof JTextField) {
            this.m_editorTextField = (JTextField)this.m_editor.getEditorComponent();
        }
        this.m_resultDataField.setEditor(this.m_editor);
        resultDataFieldPanel.add((Component)this.m_resultDataField, "Center");
        this.m_launchButton = VWImageLoader.createIconButton("dots.gif", VWResource.s_launchExpressionBuilderStr);
        this.m_launchButton.setName("m_launchButton_VWWaitForConditionParamPanel");
        this.m_launchButton.setToolTipText(VWResource.s_launchExpressionBuilderStr);
        this.m_launchButton.addActionListener(this);
        resultDataFieldPanel.add((Component)this.m_launchButton, "After");
        return this.m_resultDataFieldBorder;
    }

    private void initResultDataField() {
        VWFieldDefinition[] fields;
        this.m_resultDataField.removeItemListener(this);
        this.m_resultDataField.removeAllItems();
        if (this.m_authPropertyData != null && (fields = this.m_authPropertyData.getFields()) != null) {
            Vector<String> intFields = new Vector<String>();
            for (int nIndex = 0; nIndex < fields.length; ++nIndex) {
                if (fields[nIndex].getFieldType() != 1) continue;
                intFields.addElement(fields[nIndex].getName());
            }
            if (intFields.size() > 0) {
                Object[] sortedIntFields = new String[intFields.size()];
                intFields.copyInto(sortedIntFields);
                if (sortedIntFields.length > 1) {
                    VWQuickSort quicksort = new VWQuickSort(sortedIntFields, 0);
                    quicksort.sort(0, sortedIntFields.length - 1);
                }
                DefaultComboBoxModel<Object> cbModel = new DefaultComboBoxModel<Object>(sortedIntFields);
                this.m_resultDataField.setModel(cbModel);
            }
        }
        this.m_resultDataField.addItemListener(this);
        if (this.m_resultDataField.getItemCount() > 0) {
            this.m_resultDataField.setEnabled(true);
            this.m_launchButton.setEnabled(true);
            this.m_resultDataField.setSelectedItem(VWInstruction.WaitForEventInstructionGetEventNumLoc(this.m_instructionDef));
        } else {
            this.m_resultDataField.setEnabled(false);
            this.m_launchButton.setEnabled(false);
        }
    }

    private void performInfiniteTimeoutAction() {
        this.m_timeoutTextField.setEnabled(false);
        VWInstruction.WaitForEventInstructionSetTimeOut(this.m_instructionDef, "0");
    }

    private void performTimeoutExpressionAction() {
        this.m_timeoutTextField.setEnabled(true);
        this.m_timeoutTextField.grabFocus();
        VWInstruction.WaitForEventInstructionSetTimeOut(this.m_instructionDef, this.m_timeoutTextField.getText());
    }

    private void performConditionResultDataFieldUpdated() {
        if (this.m_editorTextField != null) {
            VWInstruction.WaitForEventInstructionSetEventNumLoc(this.m_instructionDef, this.m_editorTextField.getText());
        }
    }

    private void performTimeoutUpdated() {
        VWInstruction.WaitForEventInstructionSetTimeOut(this.m_instructionDef, this.m_timeoutTextField.getText());
    }

    private void onModifyConditionsTable() {
        int index = this.m_conditionsTable.getSelectedRow();
        if (index >= 0) {
            VWEventDefinition eventDef = this.m_conditionsTableModel.getItemAt(index);
            VWWaitForConditionDialog waitForConditionDialog = null;
            waitForConditionDialog = this.m_parentFrame != null ? new VWWaitForConditionDialog(this.m_parentFrame, this.m_authPropertyData, eventDef) : new VWWaitForConditionDialog(this.m_parentDialog, this.m_authPropertyData, eventDef);
            waitForConditionDialog.setVisible(true);
            this.m_conditionsTableModel.updateConditionInfo(index);
        }
    }

    private void performLaunchButtonAction() {
        VWExpressionBuilderDialog expressionBuilderDialog = null;
        String expressionString = this.m_editorTextField.getText();
        expressionBuilderDialog = this.m_parentFrame != null ? new VWExpressionBuilderDialog(this.m_parentFrame, (IVWPropertyData)this.m_authPropertyData, null, expressionString, 2703) : new VWExpressionBuilderDialog(this.m_parentDialog, (IVWPropertyData)this.m_authPropertyData, null, expressionString, 2703);
        expressionBuilderDialog.init();
        expressionBuilderDialog.setVisible(true);
        if (expressionBuilderDialog.getDialogResult() == 0) {
            this.m_editorTextField.setText(expressionBuilderDialog.getExpressionString());
            this.performConditionResultDataFieldUpdated();
        }
    }
}

